% 2-dimensional HP filter, triangular
% THIS WORKS ONLY FOR A SYMMETRIC FUNCTION

function HP1 = HP_2dim_triangular(Bmat,lambda)

    T1 = size(Bmat,1);
    T2 = size(Bmat,2);
    B = Bmat(:);

    AA = zeros(T1*T2,T1*T2);
    % SELECT ONLY PART WITH t1<t2
    index_select = zeros(T1*T2,1);

% FILL THE MATRIX
    for t1 = 1:T1  
        for t2 = t1:T2
            if t1 >= 3 && t1<=t2-2
                t1_shift = [-2 -1 0  1 2];
                t1_add   = [1  -4 6 -4 1];
            end
            if t1== 1        
                t1_shift = [0  1 2];
                t1_add   = [1 -2 1];
            end    
            if t1== 2        
                t1_shift = [-1 0  1 2];
                t1_add   = [-2 5 -4 1];
            end    
            if t1== t2        
                t1_shift = [-2 -1 0];
                t1_add   = [1  -2 1];
            end    
            if t1== t2-1        
                t1_shift = [-2 -1 0 1];
                t1_add   = [1  -4 5 -2];
            end        

            if t2 >= t1+2 && t2<=T2-2
                t2_shift = [-2 -1 0  1 2];
                t2_add   = [1  -4 6 -4 1];
            end
            if t2== t1        
                t2_shift = [0 1 2];
                t2_add   = [1 -2 1];
            end    
            if t2== t1+2        
                t2_shift = [-1 0 1 2];
                t2_add   = [-2 5 -4 1];
            end     
            if t2== T2              
                t2_shift = [-2 -1 0];
                t2_add   = [1  -2 1];
            end     
            if t2== T2-1        
                t2_shift = [-2 -1 0 1];
                t2_add   = [1  -4 5 -2];
            end  
            %---- Special corners
            %(1,1),(1,2),(2,2)
            if (t1==1 && t2==1) || (t1==1 && t2==2) || (t1==2 && t2==2)
                t1_shift = [];
                %t1_add   = [];
                t1_add = AA(1,[]);% this is empty object with size 1 0
            end
            %(T,T),(T-1,T),(T-1,T-1)
            if (t1==T1 && t2==T2) || (t1==T1-1 && t2==T2) || (t1==T1-1 && t2==T2-1)
                t2_shift = [];
                %t2_add   = [];
                t2_add = AA(1,[]); % this is empty object with size 1 0
            end 
            %(2,3)
            if (t1==2 && t2==3) 
                t1_shift = [-1 0  1 ];
                t1_add   = [-2 4 -2 ];
            end 
            % (T-2,T-1)
            if (t1==T1-2 && t2==T2-1) 
                t2_shift = [-1 0 1];
                t2_add   = [-2  4 -2];
            end            
            
            %-----------------------------
            row = (t1-1)*T2 + t2;
           
            pos_t1 = (t1+t1_shift-1)*T1+t2;
            pos_t2 = row + t2_shift;

            AA(row,pos_t1) =AA(row,pos_t1)+ lambda*t1_add; 
            AA(row,pos_t2) =AA(row,pos_t2)+ lambda*t2_add; 
            
            index_select(row) = 1;
            %-----------------------------
        end
    end
    

    % ADD 1 TO THE DIAGONAL
    %AA = AA+diag(ones(1,T1*T2));
    diag_elements = ([1:1:T1*T2]-1)*T1*T2 + [1:1:T1*T2];
    AA(diag_elements) = AA(diag_elements)+1;

    % SELECT ONLY RELEVANT ROWS
    AA1 = AA(index_select==1,:);
    AA2 = AA1(:,index_select==1);
    B2  = B(index_select==1);
    
    % INVERSE OF THE MATRIX
    AAs = sparse(AA2);
    ASinv = inv(AAs);
    Ainv = full(ASinv);
    
    HP = Ainv*B2;
    
    % RESHAPE THE TRIANGLE BACK TO THE RECTANGLE
    
    HP1 =  zeros(T1,T2);
    k = 0;
    for t1 = 1:T1
        for t2 = t1:T2
            k=k+1;
            HP1(t1,t2) = HP(k);
            HP1(t2,t1) = HP(k);
        end
    end
return
